-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema surveyjs
--

-- CREATE DATABASE IF NOT EXISTS surveyjs;
-- USE surveyjs;

--
-- Definition of table `status`
--

DROP TABLE IF EXISTS `status`;
CREATE TABLE `status` (
  `id_status` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `title` varchar(15) NOT NULL,
  PRIMARY KEY (`id_status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `status`
--

/*!40000 ALTER TABLE `status` DISABLE KEYS */;
INSERT INTO `status` (`id_status`,`code`,`title`) VALUES 
 (1,'developing','En Desarrollo'),
 (2,'actively','En Activo'),
 (3,'deactivate','Desactivada'),
 (4,'archived','Archivada');
/*!40000 ALTER TABLE `status` ENABLE KEYS */;


--
-- Definition of table `survey`
--

DROP TABLE IF EXISTS `survey`;
CREATE TABLE `survey` (
  `id_survey` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `code` varchar(10) NOT NULL,
  `description` varchar(200) NOT NULL,
  `welcomeMessage` mediumtext NOT NULL,
  `endMesagge` mediumtext NOT NULL,
  `json` mediumtext NOT NULL,
  `status_id` int(11) NOT NULL,
  `surveyStartDate` datetime NOT NULL,
  `surveyEndDate` datetime NOT NULL,
  `creationDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `creationUser` varchar(16) NOT NULL,
  `lastUpdateDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdateUser` varchar(16) NOT NULL,
  PRIMARY KEY (`id_survey`),
  KEY `fk_survey_status1_idx` (`status_id`),
  CONSTRAINT `fk_survey_status1` FOREIGN KEY (`status_id`) REFERENCES `status` (`id_status`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `survey`
--

/*!40000 ALTER TABLE `survey` DISABLE KEYS */;
INSERT INTO `survey` (`id_survey`,`title`,`code`,`description`,`welcomeMessage`,`endMesagge`,`json`,`status_id`,`surveyStartDate`,`surveyEndDate`,`creationDate`,`creationUser`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (1,'Ejemplo de Encuesta','survey_001','Test de funcionamiento','<h3 align=\"center\"><strong>Ejemplo de encuesta</strong><br></h3>','<p>Muchas gracias por participar en esta encuesta.<br></p>','var json = {\r\n    \"completedHtml\": \"<h3>Gracias por sus comentarios. </h3> <h5> ¡Sus sugerencias e ideas nos ayudarán a crear un gran producto! </h5>\",\r\n    \"completedHtmlOnCondition\": [\r\n        {\r\n            \"expression\": \"{nps_score} > 8\",\r\n            \"html\": \"<h3>Gracias por tus comentarios. </h3><h5> Nos alegramos de que te guste nuestro producto. ¡Tus ideas y sugerencias nos ayudarán a hacer que nuestro producto sea aún mejor! </h5>\"\r\n        }, {\r\n            \"expression\": \"{nps_score} < 7\",\r\n            \"html\": \"<h3>Gracias por tus comentarios. </h3><h5>Nos alegra que compartas con nosotros tus ideas. Las sugerencias de nuestros clientes son de vital importancia. Con ellas queremos mejorar el producto y deseamos cumplir con sus expectativas.</h5><br/>\"\r\n        }\r\n    ],\r\n    \"pages\": [\r\n        {\r\n            \"name\": \"page1\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"rating\",\r\n                    \"name\": \"nps_score\",\r\n                    \"title\": \"En una escala de cero a diez, ¿qué tan probable es que recomiende nuestro producto a un amigo o colega?\",\r\n                    \"isRequired\": true,\r\n                    \"rateMin\": 0,\r\n                    \"rateMax\": 10,\r\n                    \"minRateDescription\": \"(Lo más improbable)\",\r\n                    \"maxRateDescription\": \"(Más probable)\"\r\n                }, {\r\n                    \"type\": \"checkbox\",\r\n                    \"name\": \"promoter_features\",\r\n                    \"visibleIf\": \"{nps_score} >= 9\",\r\n                    \"title\": \"¿Qué características valoras más?\",\r\n                    \"isRequired\": true,\r\n                    \"validators\": [\r\n                        {\r\n                            \"type\": \"answercount\",\r\n                            \"text\": \"Por favor, seleccione dos características máximo.\",\r\n                            \"maxCount\": 2\r\n                        }\r\n                    ],\r\n                    \"hasOther\": true,\r\n                    \"choices\": [\r\n                        \"Rendimiento\", \"Estabilidad\", \"Interfaz de usuario\", \"Funcionalidad completa\"\r\n                    ],\r\n                    \"otherText\": \"Otra característica:\",\r\n                    \"colCount\": 2\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"name\": \"passive_experience\",\r\n                    \"visibleIf\": \"{nps_score} > 6  and {nps_score} < 9\",\r\n                    \"title\": \"¿Cuál es la razón principal de su puntaje?\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"name\": \"disappointed_experience\",\r\n                    \"visibleIf\": \"{nps_score} notempty\",\r\n                    \"title\": \"¿Qué extrañas y qué fue decepcionante en tu experiencia con nosotros?\"\r\n                }\r\n            ]\r\n        }\r\n    ],\r\n    \"showQuestionNumbers\": \"off\"\r\n};',2,'2021-12-09 00:00:00','2021-12-30 23:55:55','2021-12-09 18:23:45','admin','2021-12-09 23:20:45','admin'),
 (2,'Satisfaction survey','survey_002','Encuesta de satisfacción','<h3 style=\"text-align: center;\">Satisfaction Survey</h3><p>This is an example copied directly from the examples page of \"<span style=\"font-size: large;\"><strong>survejs.io</strong></span>\". There are many examples, very illustrative and a tool to create and customize all these cases.<br></p>','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n \"pages\": [\r\n  {\r\n   \"name\": \"page1\",\r\n   \"elements\": [\r\n    { \"type\": \"rating\", \"name\": \"satisfaction\", \"title\": \"How satisfied are you with the Product?\", \"mininumRateDescription\": \"Not Satisfied\", \"maximumRateDescription\": \"Completely satisfied\" },\r\n    {\r\n      \"type\": \"panel\",\r\n      \"innerIndent\": 1,\r\n      \"name\": \"panel1\",\r\n      \"title\": \"Please, help us improve our product\",\r\n      \"visibleIf\": \"{satisfaction} < 3\",\r\n      \"elements\": [\r\n        {\r\n          \"type\": \"checkbox\",\r\n          \"choices\": [\r\n            {\r\n              \"value\": \"1\",\r\n              \"text\": \"Customer relationship\"\r\n            },\r\n            {\r\n              \"value\": \"2\",\r\n              \"text\": \"Service quality\"\r\n            },\r\n            {\r\n              \"value\": \"3\",\r\n              \"text\": \"Support response time\"\r\n            }\r\n          ],\r\n          \"name\": \"What should be improved?\"\r\n        },\r\n        {\r\n          \"type\": \"comment\",\r\n          \"name\": \"suggestions\",\r\n          \"title\": \"What would make you more satisfied with the Product?\"\r\n        },\r\n        {\r\n         \"type\": \"panel\", \"innerIndent\": 1, \"name\": \"panel2\", \"title\": \"Send us your contact information (optionally)\", \"state\":  \"collapsed\",\r\n         \"elements\": [\r\n            { \"type\": \"text\",\"name\":  \"name\", \"title\":  \"Name:\" },\r\n            { \"type\": \"text\", \"inputType\": \"email\",\"name\":  \"email\", \"title\":  \"E-mail\"  }\r\n         ]\r\n        }\r\n      ]\r\n    }\r\n   ]\r\n  }\r\n ]\r\n};',2,'2021-12-09 18:47:20','2021-12-31 18:47:28','2021-12-11 18:43:20','admin','2021-12-11 19:05:10','admin'),
 (3,'Matric cell in several columns','survey_003','Matric cell in several columns','<h2 style=\"text-align: center;\">Matric cell in several columns<br></h2>','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    showQuestionNumbers: \"off\",\r\n    questions: [\r\n        {\r\n            type: \"matrixdropdown\",\r\n            name: \"Feelings\",\r\n            title: \"What do your feel?\",\r\n\r\n            columns: [\r\n                {\r\n                    name: \"col1\",\r\n                    cellType: \"radiogroup\",\r\n                    showInMultipleColumns: true,\r\n                    isRequired: true,\r\n                    choices: [\"Strongly disagree\", \"Disagree\", \"Neutral\", \"Agree\", \"Strongly agree\"]\r\n                }, {\r\n                    name: \"comment\",\r\n                    title: \"Please comment\",\r\n                    cellType: \"comment\"\r\n                }\r\n            ],\r\n            rows: [\r\n                \"Excited\",\r\n                \"Enthusiastic\",\r\n                \"Open\",\r\n                \"Physically safe\",\r\n                \"Emotionally safe\",\r\n                \"Apprehensive\",\r\n                \"Nervous\",\r\n                \"Scared\"\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 19:22:01','admin'),
 (4,'Matrixdynamic/dropdown detail panel','survey_004','Matrixdynamic/dropdown detail panel\r\n','<h2 class=\"examples-page__example-header\" title=\"Matrixdynamic/dropdown detail panel\" style=\"text-align: center;\">Matrixdynamic/dropdown detail panel</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"checkErrorsMode\": \"onValueChanged\",\r\n    \"pages\": [\r\n        {\r\n            \"name\": \"page1\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"matrixdynamic\",\r\n                    \"name\": \"relatives\",\r\n                    \"title\": \"Please enter all blood relatives you know\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"relativeType\",\r\n                            \"title\": \"Relative\",\r\n                            \"cellType\": \"dropdown\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"father\",\r\n                                \"mother\",\r\n                                \"brother\",\r\n                                \"sister\",\r\n                                \"son\",\r\n                                \"daughter\"\r\n                            ]\r\n                        }, {\r\n                            \"name\": \"firstName\",\r\n                            \"title\": \"First name\",\r\n                            \"cellType\": \"text\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"name\": \"lastName\",\r\n                            \"title\": \"Last name\",\r\n                            \"cellType\": \"text\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"detailElements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"name\": \"isalive\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Alive?\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"Yes\", \"No\"\r\n                            ],\r\n                            \"colCount\": 0\r\n                        }, {\r\n                            \"type\": \"dropdown\",\r\n                            \"name\": \"liveage\",\r\n                            \"visibleIf\": \"{row.isalive} = \'Yes\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Age\",\r\n                            \"isRequired\": true,\r\n                            \"choicesMin\": 1,\r\n                            \"choicesMax\": 115\r\n                        }, {\r\n                            \"type\": \"dropdown\",\r\n                            \"name\": \"deceasedage\",\r\n                            \"visibleIf\": \"{row.isalive} = \'No\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Deceased Age\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": -1,\r\n                                    \"text\": \"Unknown\"\r\n                                }\r\n                            ],\r\n                            \"choicesMin\": 1,\r\n                            \"choicesMax\": 115\r\n                        }, {\r\n                            \"type\": \"radiogroup\",\r\n                            \"name\": \"causeofdeathknown\",\r\n                            \"visibleIf\": \"{row.isalive} = \'No\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Cause of Death Known?\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"Yes\", \"No\"\r\n                            ],\r\n                            \"colCount\": 0\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"causeofdeath\",\r\n                            \"visibleIf\": \"{row.isalive} = \'No\' and {row.causeofdeathknown} = \'Yes\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Cause of Death\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"detailPanelMode\": \"underRow\",\r\n                    \"rowCount\": 1,\r\n                    \"addRowText\": \"Add a blood relative\",\r\n                    \"removeRowText\": \"Remove the relative\"\r\n                }\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 19:22:01','admin'),
 (5,'Start With New Line','survey_005','Start With New Line\r\n','<h2 class=\"examples-page__example-header\" title=\"Start With New Line\" style=\"text-align: center;\">Start With New Line</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    questionTitleLocation: \"bottom\",\r\n    showQuestionNumbers: \"off\",\r\n    pages: [\r\n        {\r\n            name: \"Address\",\r\n            title: \"Address\",\r\n            questions: [\r\n                {\r\n                    type: \"text\",\r\n                    name: \"address1\",\r\n                    title: \"Street Address\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"address2\",\r\n                    title: \"Address Line 2\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"city\",\r\n                    title: \"City\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"state\",\r\n                    startWithNewLine: false,\r\n                    title: \"State / Province / Region\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"zip\",\r\n                    title: \"Zip / Postal Code\"\r\n                }, {\r\n                    type: \"dropdown\",\r\n                    name: \"country\",\r\n                    startWithNewLine: false,\r\n                    title: \"Country\",\r\n                    choicesByUrl: {\r\n                        url: \"https://surveyjs.io/api/CountriesExample\",\r\n                        valueName: \"name\"\r\n                    }\r\n                }\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 19:52:24','admin'),
 (6,'Quiz','survey_006','Quiz\r\n\r\n','<h2 class=\"examples-page__example-header\" title=\"Quiz\" style=\"text-align: center;\">Quiz</h2>\r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    title: \"American History\",\r\n    showProgressBar: \"bottom\",\r\n    showTimerPanel: \"top\",\r\n    maxTimeToFinishPage: 10,\r\n    maxTimeToFinish: 25,\r\n    firstPageIsStarted: true,\r\n    startSurveyText: \"Start Quiz\",\r\n    pages: [\r\n        {\r\n            questions: [\r\n                {\r\n                    type: \"html\",\r\n                    html: \"You are about to start quiz by history. <br/>You have 10 seconds for every page and 25 seconds for the whole survey of 3 questions.<br/>Please click on <b>\'Start Quiz\'</b> button when you are ready.\"\r\n                }\r\n            ]\r\n        }, {\r\n            questions: [\r\n                {\r\n                    type: \"radiogroup\",\r\n                    name: \"civilwar\",\r\n                    title: \"When was the Civil War?\",\r\n                    choices: [\r\n                        \"1750-1800\", \"1800-1850\", \"1850-1900\", \"1900-1950\", \"after 1950\"\r\n                    ],\r\n                    correctAnswer: \"1850-1900\"\r\n                }\r\n            ]\r\n        }, {\r\n            questions: [\r\n                {\r\n                    type: \"radiogroup\",\r\n                    name: \"libertyordeath\",\r\n                    title: \"Who said \'Give me liberty or give me death?\'\",\r\n                    choicesOrder: \"random\",\r\n                    choices: [\r\n                        \"John Hancock\", \"James Madison\", \"Patrick Henry\", \"Samuel Adams\"\r\n                    ],\r\n                    correctAnswer: \"Patrick Henry\"\r\n                }\r\n            ]\r\n        }, {\r\n            maxTimeToFinish: 15,\r\n            questions: [\r\n                {\r\n                    type: \"radiogroup\",\r\n                    name: \"magnacarta\",\r\n                    title: \"What is the Magna Carta?\",\r\n                    choicesOrder: \"random\",\r\n                    choices: [\r\n                        \"The foundation of the British parliamentary system\", \"The Great Seal of the monarchs of England\", \"The French Declaration of the Rights of Man\", \"The charter signed by the Pilgrims on the Mayflower\"\r\n                    ],\r\n                    correctAnswer: \"The foundation of the British parliamentary system\"\r\n                }\r\n            ]\r\n        }\r\n    ],\r\n    completedHtml: \"<h4>You have answered correctly <b>{correctedAnswers}</b> questions from <b>{questionCount}</b>.</h4>\"\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 19:52:24','admin'),
 (7,'Survey Data','survey_007','Survey Data','<h2 class=\"examples-page__example-header\" title=\"Survey Data\" style=\"text-align: center;\">Survey Data</h2>\r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"pages\": [\r\n        {\r\n            \"name\": \"page1\",\r\n            \"title\": \"Who are you employed by?\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"matrixdynamic\",\r\n                    \"minRowCount\": 1,\r\n                    \"rowCount\": 1,\r\n                    \"name\": \"employer_names\",\r\n                    \"valueName\": \"employers\",\r\n                    \"isRequired\": true,\r\n                    \"title\": \"Please enter all your employers\",\r\n                    \"addRowText\": \"Add another employer\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"name\",\r\n                            \"isRequired\": true,\r\n                            \"title\": \"Name of employer\",\r\n                            \"cellType\": \"text\"\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        }, {\r\n            \"name\": \"page2\",\r\n            \"title\": \"Tells us about your employer(s)\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"paneldynamic\",\r\n                    \"renderMode\": \"list\",\r\n                    \"allowAddPanel\": false,\r\n                    \"allowRemovePanel\": false,\r\n                    \"name\": \"arrray_employer_info\",\r\n                    \"title\": \"Your employers\",\r\n                    \"valueName\": \"employers\",\r\n                    \"templateTitle\": \"Employer name: {panel.name}\",\r\n                    \"templateElements\": [\r\n                        {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_mployer_address\",\r\n                            \"title\": \"Address\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"employer_address\",\r\n                                    \"valueName\": \"address\",\r\n                                    \"title\": \"Address\"\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"employer_phone\",\r\n                                    \"valueName\": \"phone\",\r\n                                    \"title\": \"Phone number:\"\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"employer_abn\",\r\n                                    \"valueName\": \"abn\",\r\n                                    \"title\": \"ABN\"\r\n                                }\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_employer_role\",\r\n                            \"title\": \"What is your role?\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"Full time\", \"Part time\", \"Casual\", \"Seasonal\"\r\n                                    ],\r\n                                    \"name\": \"employer_role\",\r\n                                    \"title\": \"Your role\",\r\n                                    \"valueName\": \"role\"\r\n                                }\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_employer_hours_work\",\r\n                            \"title\": \"What hours do you work?\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"inputType\": \"number\",\r\n                                    \"name\": \"member_hours_worked\",\r\n                                    \"valueName\": \"hours_worked\",\r\n                                    \"title\": \"Hours:\"\r\n                                }, {\r\n                                    \"type\": \"dropdown\",\r\n                                    \"name\": \"member_hours_worked_frequency\",\r\n                                    \"title\": \"Worked Frequency:\",\r\n                                    \"valueName\": \"hours_worked_frequency\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"defaultValue\": \"Year\",\r\n                                    \"choices\": [\"Day\", \"Week\", \"Fortnight\", \"Month\", \"Year\"]\r\n                                }\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_employer_income\",\r\n                            \"title\": \"What income do you receive?\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"inputType\": \"number\",\r\n                                    \"name\": \"employer_income\",\r\n                                    \"valueName\": \"income\",\r\n                                    \"title\": \"Income:\"\r\n                                }, {\r\n                                    \"type\": \"dropdown\",\r\n                                    \"name\": \"employer_income_frequency\",\r\n                                    \"title\": \"Income Frequency\",\r\n                                    \"valueName\": \"income_frequency\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"defaultValue\": \"Year\",\r\n                                    \"choices\": [\"Day\", \"Week\", \"Fortnight\", \"Month\", \"Year\"]\r\n                                }\r\n                            ]\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        }\r\n    ],\r\n    \"showQuestionNumbers\": \"off\"\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 20:09:32','admin'),
 (8,'Custom Render of Survey Elements','survey_008','Custom Render of Survey Elements','<h2 class=\"examples-page__example-header\" title=\"Custom Render of Survey Elements\" style=\"text-align: center;\">Custom Render of Survey Elements</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','//Add a custom \'popupdescription\' property to questions of all types and to pages\r\nSurvey\r\n    .Serializer\r\n    .addProperty(\"question\", \"popupdescription:text\");\r\nSurvey\r\n    .Serializer\r\n    .addProperty(\"page\", \"popupdescription:text\");\r\nfunction showDescription(element) {\r\n    document\r\n        .getElementById(\"questionDescriptionText\")\r\n        .innerHTML = element.popupdescription;\r\n    $(\"#questionDescriptionPopup\").modal();\r\n}\r\n\r\nvar json = {\r\n    title: \"Software developer survey.\",\r\n    pages: [\r\n        {\r\n            title: \"What operating system do you use?\",\r\n            popupdescription: \"Select the operating system you are currently using.\",\r\n            questions: [\r\n                {\r\n                    type: \"checkbox\",\r\n                    name: \"opSystem\",\r\n                    title: \"OS\",\r\n                    hasOther: true,\r\n                    isRequired: true,\r\n                    popupdescription: \"If you do not use any of the listed operating system, please select \'others\' and type your operating system name.\",\r\n                    choices: [\"Windows\", \"Linux\", \"Macintosh OSX\"]\r\n                }\r\n            ]\r\n        }, {\r\n            title: \"What language(s) are you currently using?\",\r\n            popupdescription: \"Select all programming languages you have been using for the last six months.\",\r\n            questions: [\r\n                {\r\n                    type: \"checkbox\",\r\n                    name: \"langs\",\r\n                    title: \"Please select from the list\",\r\n                    popupdescription: \"Select all programming languages you have been using for the last six months.\",\r\n                    colCount: 4,\r\n                    isRequired: true,\r\n                    choices: [\r\n                        \"Javascript\",\r\n                        \"Java\",\r\n                        \"Python\",\r\n                        \"CSS\",\r\n                        \"PHP\",\r\n                        \"Ruby\",\r\n                        \"C++\",\r\n                        \"C\",\r\n                        \"Shell\",\r\n                        \"C#\",\r\n                        \"Objective-C\",\r\n                        \"R\",\r\n                        \"VimL\",\r\n                        \"Go\",\r\n                        \"Perl\",\r\n                        \"CoffeeScript\",\r\n                        \"TeX\",\r\n                        \"Swift\",\r\n                        \"Scala\",\r\n                        \"Emacs Lisp\",\r\n                        \"Haskell\",\r\n                        \"Lua\",\r\n                        \"Clojure\",\r\n                        \"Matlab\",\r\n                        \"Arduino\",\r\n                        \"Makefile\",\r\n                        \"Groovy\",\r\n                        \"Puppet\",\r\n                        \"Rust\",\r\n                        \"PowerShell\"\r\n                    ]\r\n                }\r\n            ]\r\n        }, {\r\n            title: \"Please enter your name and e-mail\",\r\n            popupdescription: \"We will not share this information with any third-party organization.\",\r\n            questions: [\r\n                {\r\n                    type: \"text\",\r\n                    name: \"name\",\r\n                    title: \"Name:\",\r\n                    popupdescription: \"Please, type your name as \'Given Name\' \'Family Name\'.\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"email\",\r\n                    title: \"Your e-mail\",\r\n                    popupdescription: \"Please, make sure you do not misspell your e-mail.\"\r\n                }\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 20:09:45','admin'),
 (9,'Datepicker','survey_009','Datepicker\r\n\r\n','<h2 class=\"examples-page__example-header\" title=\"Bootstrap Datepicker\" style=\"text-align: center;\">Datepicker</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"elements\": [\r\n        {\r\n            \"name\": \"date\",\r\n            \"type\": \"datepicker\",\r\n            \"inputType\": \"date\",\r\n            \"title\": \"Your favorite date:\",\r\n            \"dateFormat\": \"mm/dd/yy\",\r\n            \"isRequired\": true\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2022-01-08 19:23:16','2021-12-11 19:22:01','admin','2021-12-11 20:21:07','admin');
/*!40000 ALTER TABLE `survey` ENABLE KEYS */;


--
-- Definition of table `response`
--

DROP TABLE IF EXISTS `response`;
CREATE TABLE `response` (
  `id_response` int(11) NOT NULL AUTO_INCREMENT,
  `survey_id` int(11) NOT NULL,
  `status` varchar(1) NOT NULL DEFAULT '0',
  `responseDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip` varchar(15) DEFAULT NULL,
  `json` mediumtext NOT NULL,
  PRIMARY KEY (`id_response`),
  KEY `fk_response_survey1_idx` (`survey_id`),
  CONSTRAINT `fk_response_survey1` FOREIGN KEY (`survey_id`) REFERENCES `survey` (`id_survey`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `response`
--

/*!40000 ALTER TABLE `response` DISABLE KEYS */;
INSERT INTO `response` (`id_response`,`survey_id`,`status`,`responseDate`,`ip`,`json`) VALUES 
 (1,1,'1','2021-12-09 18:59:26','127.0.0.1','{\r\n   \"nps_score\": 10,\r\n   \"promoter_features\": [\r\n      \"Stability\",\r\n      \"Complete Functionality\"\r\n   ],\r\n   \"disappointed_experience\": \"Esto es una prueba\"\r\n}'),
 (2,1,'1','2021-12-10 17:51:27','127.0.0.1','{\"nps_score\":8,\"passive_experience\":\"Pruebas 1\",\"disappointed_experience\":\"Pruebas2\"}'),
 (3,1,'1','2021-12-10 17:54:49','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Rendimiento\",\"Funcionalidad completa\"],\"disappointed_experience\":\"Pruebas 1\"}'),
 (4,1,'1','2021-12-10 17:55:39','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"other\"],\"disappointed_experience\":\"Pruebas 2\",\"promoter_features-Comment\":\"Pruebas 1\"}'),
 (5,1,'1','2021-12-10 19:28:42','127.0.0.1','{\"nps_score\":7,\"passive_experience\":\"vcvc\",\"disappointed_experience\":\"vcvcgtgttt\"}'),
 (6,1,'1','2021-12-10 19:36:51','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Estabilidad\",\"Interfaz de usuario\"],\"disappointed_experience\":\"dedede\"}'),
 (7,1,'1','2021-12-10 19:38:02','127.0.0.1','{\"nps_score\":7,\"passive_experience\":\"frfr\",\"disappointed_experience\":\"frfrf\"}'),
 (8,1,'1','2021-12-10 19:44:41','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Estabilidad\",\"Rendimiento\"],\"disappointed_experience\":\"Pruebas 1\"}'),
 (9,1,'1','2021-12-10 20:45:43','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Estabilidad\",\"Interfaz de usuario\"],\"disappointed_experience\":\"gtgtg\"}'),
 (10,1,'1','2021-12-10 20:57:30','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Estabilidad\",\"Interfaz de usuario\"],\"disappointed_experience\":\"frfrfrf\"}'),
 (11,2,'1','2021-12-11 18:54:38','127.0.0.1','{\"satisfaction\":3}'),
 (12,2,'1','2021-12-11 19:15:20','127.0.0.1','{\"satisfaction\":2,\"What should be improved?\":[\"1\",\"2\",\"3\"],\"suggestions\":\"Texto de prueba\",\"name\":\"Fernando\",\"email\":\"info@fhumanes.com\"}'),
 (13,3,'1','2021-12-11 19:25:47','127.0.0.1','{\"Feelings\":{\"Excited\":{\"col1\":\"Disagree\",\"comment\":\"Comment 1\"},\"Enthusiastic\":{\"col1\":\"Agree\",\"comment\":\"Comment 2\"},\"Open\":{\"col1\":\"Disagree\",\"comment\":\"Comment 3\"},\"Physically safe\":{\"col1\":\"Strongly disagree\",\"comment\":\"Comment 4\"},\"Emotionally safe\":{\"col1\":\"Agree\",\"comment\":\"Comment 5\"},\"Apprehensive\":{\"col1\":\"Strongly disagree\",\"comment\":\"Comment 6\"},\"Nervous\":{\"col1\":\"Disagree\",\"comment\":\"Comment 7\"},\"Scared\":{\"col1\":\"Agree\",\"comment\":\"Comment 8\"}}}'),
 (14,4,'1','2021-12-11 19:34:25','127.0.0.1','{\"relatives\":[{\"isalive\":\"Yes\",\"relativeType\":\"father\",\"firstName\":\"Fernando\",\"lastName\":\"H\",\"liveage\":60},{\"isalive\":\"Yes\",\"relativeType\":\"mother\",\"firstName\":\"Ángela\",\"lastName\":\"L\",\"liveage\":60},{\"isalive\":\"Yes\",\"relativeType\":\"mother\",\"firstName\":\"Rosa\",\"lastName\":\"G\",\"liveage\":80},{\"isalive\":\"Yes\",\"relativeType\":\"son\",\"firstName\":\"Pablo\",\"lastName\":\"H\",\"liveage\":32},{\"isalive\":\"Yes\",\"relativeType\":\"brother\",\"firstName\":\"Ángel\",\"lastName\":\"U\",\"liveage\":48}]}'),
 (15,4,'1','2021-12-11 19:36:21','127.0.0.1','{\"relatives\":[{\"isalive\":\"No\",\"deceasedage\":86,\"causeofdeathknown\":\"Yes\",\"relativeType\":\"father\",\"firstName\":\"Ángel\",\"lastName\":\"H\",\"causeofdeath\":\"other\"}]}'),
 (16,5,'1','2021-12-11 19:50:35','127.0.0.1','{\"address1\":\"Calle Alcala, 32\",\"address2\":\"Hotel\",\"city\":\"Madrid\",\"state\":\"Madrid\",\"zip\":\"28015\",\"country\":\"Spain\"}'),
 (17,6,'1','2021-12-11 19:55:34','127.0.0.1','{\"civilwar\":\"1800-1850\",\"libertyordeath\":\"Samuel Adams\",\"magnacarta\":\"The Great Seal of the monarchs of England\"}'),
 (18,7,'1','2021-12-11 20:01:12','127.0.0.1','{\"employers\":[{\"name\":\"fernando\",\"hours_worked_frequency\":\"Year\",\"income_frequency\":\"Year\",\"address\":\"Calle Alcalá, 32\",\"phone\":\"630630630\",\"role\":\"Full time\",\"hours_worked\":8,\"income\":1500}]}'),
 (19,8,'1','2021-12-11 20:10:25','127.0.0.1','{\"opSystem\":[\"Windows\"],\"langs\":[\"PHP\",\"Javascript\"],\"name\":\"fernando\",\"email\":\"info@fhumanes.com\"}'),
 (20,9,'1','2021-12-11 20:38:29','127.0.0.1','{\"date\":\"12/15/2021\"}');
/*!40000 ALTER TABLE `response` ENABLE KEYS */;

--
-- Definition of table `user`
--

DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `id_user` int(11) NOT NULL,
  `login` varchar(16) NOT NULL,
  `password` varchar(100) NOT NULL,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user`
--

/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id_user`,`login`,`password`,`name`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Administrator');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
